(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     29488,        859]*)
(*NotebookOutlinePosition[     30861,        899]*)
(*  CellTagsIndexPosition[     30817,        895]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Derivadas ", "Title"],

Cell[TextData[StyleBox["\nDepartamento de An\[AAcute]lisis Matem\[AAcute]tico\
\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que debes aprender en este cuaderno es lo que sigue.
Representar gr\[AAcute]ficamente rectas tangentes y normales a la \
gr\[AAcute]fica de una funci\[OAcute]n.
Calcular y evaluar derivadas de cualquier orden de una funci\[OAcute]n.
Calcular extremos de funciones reales de una variable.
Calcular polinomios de Taylor y representarlos gr\[AAcute]ficamente para \
aproximar una funci\[OAcute]n.\
\>", "Text"],

Cell["\<\
Derivada de una funci\[OAcute]n. Observaciones sobre la definic\[OAcute]n de \
derivadas\
\>", "Section"],

Cell[TextData[{
  "Es muy f\[AAcute]cil representar las derivadas de primero, segundo y \
tercer orden de una funci\[OAcute]n de una variable. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lo hace igual que t\[UAcute]. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(f[x_] := x^4\  + Sin[x^2]\n\), 
    \(\(f'\)[x]\ 
     (*\ para\ escribir\ '\ debes\ usar\ la\ tecla\ junto\ al\ cero\ *) \n\), 
  
    \(\(\(f'\)'\)[x]\n\), 
    \(\(\(\(f'\)'\)'\)[x]\)}], "Input"],

Cell[TextData[{
  "Por tanto, definida una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)]],
  " de una variable ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe derivarla y no necesitas definir aparte su derivada ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\ '\)[x]\)]],
  ". Para derivadas de orden mayor esta notaci\[OAcute]n puede ser algo \
confusa (piensa en escribir la derivada de orden 10). Es m\[AAcute]s c\
\[OAcute]modo usar el comando \"D[f[x],{x,n}]\" (que tambi\[EAcute]n se puede \
escribir ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_{1, n}f\)]],
  ") que proporciona la derivada n-\[EAcute]sima. Hay una sutileza que debes \
tener en cuenta al definir derivadas. El siguiente ejemplo la pone de \
manifiesto."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\[IndentingNewLine]\), 
    \(f[x_] := x^2*Tan[x]\n\), 
    \(h[x_] := D[f[x], {x, 5}]\)}], "Input"],

Cell[BoxData[
    \(h[3]\)], "Input"],

Cell["\[DownQuestion]Entiendes lo que pasa? Veamos.", "Text"],

Cell[BoxData[
    \(FullForm[h[3]]\)], "Input"],

Cell[TextData[{
  "Ahora ya debes saber lo que est\[AAcute] pasando. Al definir h[x] con una \
igualdad diferida (:=) lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha almacenado como definici\[OAcute]n de h[x] ",
  StyleBox["no",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es la derivada quinta de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\^2\),
            "TraditionalForm"], \(Tan[x]\)}], TraditionalForm]]],
  " sino el comando ",
  Cell[BoxData[
      \(TraditionalForm\`"D[f[x], {x, 5}]"\)]],
  "  pero dicho comando no se ha ejecutado pues se trata de una ",
  StyleBox["asignaci\[OAcute]n diferida",
    FontSlant->"Italic"],
  " por lo que dicho comando se ejecuta ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de que se llama a la funci\[OAcute]n h[x]. Por eso cuando escribes h[3] \
lo que est\[AAcute]s diciendo a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es que derive f[3] respecto a la variable 3 cinco veces y, claro est\
\[AAcute], 3 no es una variable v\[AAcute]lida para derivar. Naturalmente, \
esto se arregla definiendo h[x] con la asignaci\[OAcute]n inmediata (=)."
}], "Text"],

Cell[BoxData[{
    \(Clear[h]\n\), 
    \(h[x_] = D[f[x], {x, 5}]; \n\nh[3]\)}], "Input"],

Cell[TextData[{
  "La diferencia est\[AAcute] en que ahora ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ejecuta inmediatamente el comando ",
  "D[f[x], {x, 5}] y su resultado lo asigna a h[x]."
}], "Text"],

Cell[CellGroupData[{

Cell["Rectas tangentes y secantes a una curva", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a utilizar lo que sabemos de \
pr\[AAcute]cticas anteriores para visualizar la interpretaci\[OAcute]n geom\
\[EAcute]trica de la derivada. Conviene recordar que si ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es una funci\[OAcute]n derivable en el punto ",
  StyleBox["a, ",
    FontSlant->"Italic"],
  "el valor de su derivada en ese punto, ",
  StyleBox["f '(a)",
    FontSlant->"Italic"],
  ", es la pendiente de la recta tangente a la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en el punto ",
  StyleBox["(a,f(a))",
    FontSlant->"Italic"],
  ". \nLa recta que pasa por dos puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, c)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((b, d)\)\ \)\)]],
  "con ",
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] b\)]],
  StyleBox[", ",
    FontSlant->"Italic"],
  "tiene como ecuaci\[OAcute]n cartesiana ",
  Cell[BoxData[
      \(TraditionalForm
      \`y = \(\(c - d\)\/\(a - b\)\) x + \(a\ d - b\ c\)\/\(a - b\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[{
    \(\(recta[{a_, c_}, {b_, d_}]\)[x_] := 
      \(c - d\)\/\(a - b\)*x + \(a*d - b*c\)\/\(a - b\) /; a \[NotEqual] b\n
    \), 
    \(\ \(recta[{a_, c_}, {a_, d_}]\)[x_] := "\<es una recta vertical\>"\)}], 
  "Input"],

Cell[TextData[{
  "La tangente a la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " es la recta de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y - f(a) = f\ ' \((a)\) \((x - a)\)\)]],
  ". Definimos el comando siguiente que nos calcula dicha recta:"
}], "Text"],

Cell[BoxData[
    \(\(tangente[f_, a_]\)[x_] := f[a] + \(f'\)[a]*\((x - a)\)\)], "Input"],

Cell[TextData[{
  "Ahora puedes representar gr\[AAcute]ficamente una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", su tangente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((a, f(a))\)\ \)\)]],
  "y las rectas secantes por los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((a + h, f(a + h))\)\)]],
  " para distintos valores de ",
  StyleBox["h",
    FontSlant->"Italic"],
  ".  En la siguiente animaci\[OAcute]n se ve la gr\[AAcute]fica de la par\
\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 6 - \((x - 3)\)\^2\)]],
  " en azul, la recta tangente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, f(1))\)\)]],
  " en negro y las rectas secantes en rojo."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] := \(-\((x - 3)\)^2\) + 6; \n\n
    Table[Plot[{f[x], \(tangente[f, 1]\)[x], 
          \(recta[{1, f[1]}, {1 - h, f[1 - h]}]\)[x]}, {x, \(-2\), 5}, 
        PlotRange \[Rule] {\(-2\), 8}, 
        PlotStyle
           -> {RGBColor[0, 0, 1], RGBColor[0, 0, 0], RGBColor[1, 0, 0]}], {h, 
        \(-3\), \(-.2\), .2}]; \)}], "Input"]
}, Open  ]],

Cell[TextData[{
  "Aqu\[IAcute] tienes la familia de las tangentes a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\/\(4.\)\)]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]; f[x_] := x^2/4\n\), 
    \(\(Show[\[IndentingNewLine]\t
      Table[\[IndentingNewLine]\t\t
        Plot[{f[x], \(tangente[f, \(-3\) + 6  k/30]\)[x]}, {x, \(-3\), 3}, 
          PlotRange \[Rule] {\(-2\), 2.5}, 
          PlotStyle \[Rule] {{Hue[0], Thickness[.01]}, {Hue[.65]}}, 
          AspectRatio \[Rule] 1.1, 
          DisplayFunction \[Rule] Identity\[IndentingNewLine]\t\t\t], 
        \[IndentingNewLine]{k, 1, 29}], \[IndentingNewLine]\t\t
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell[CellGroupData[{

Cell["Cocientes incrementales", "Section"],

Cell["\<\
Podemos aproximar la derivada de una funci\[OAcute]n por los cocientes \
incrementales. \
\>", "Text"],

Cell[BoxData[
    \(\(\(cocienteinc[f_, h_]\)[x_] := \(\(f[x + h] - f[x]\)\/h\ \) (*
      para\ valores\ peque\[NTilde]os\ de\ h\ tenemos\ una\ funci\[OAcute]n\ 
        que\ aproxima\ a\ la\ derivada\ de\ f*) \)\)], "Input"]
}, Open  ]],

Cell[TextData[{
  "Tendr\[IAcute]amos que calcular el l\[IAcute]mite cuando ",
  StyleBox["h",
    FontSlant->"Italic"],
  " tiende a cero de los cocientes incrementales. Veamos un ejemplo con la   \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x\^2\)\)]],
  ":"
}], "Text"],

Cell[BoxData[
    \(g[x_] = x^2\)], "Input"],

Cell[BoxData[
    \(\(cocienteinc[g, h]\)[x]\)], "Input"],

Cell[BoxData[
    \(Limit[\(cocienteinc[g, h]\)[x], h -> 0]\)], "Input"],

Cell["M\[AAcute]ximos y m\[IAcute]nimos relativos", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a aprender a localizar extemos relativos de \
una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Para ello encontraremos las soluciones de la ecuaci\[OAcute]n de punto \
cr\[IAcute]tico: ",
  StyleBox["f '(x)=0",
    FontSlant->"Italic"],
  ". Y para resolver dicha ecuaci\[OAcute]n podemos usar, cuando sea posible \
por la simplicidad de la ecuaci\[OAcute]n, comandos directos como ",
  StyleBox["Solve",
    FontWeight->"Bold"],
  " o ",
  StyleBox["Reduce",
    FontWeight->"Bold"],
  ", o bien usaremos  comandos que nos calculen soluciones aproximadas como ",
  
  StyleBox["NSolve",
    FontWeight->"Bold"],
  " o ",
  StyleBox["FindRoot",
    FontWeight->"Bold"],
  " cuando las soluciones no se puedan obtener directamente.\n"
}], "Text"],

Cell["Ejemplo", "Subsubsection"],

Cell[TextData[{
  "Comencemos buscando los extremos relativos de la funci\[OAcute]n polin\
\[OAcute]mica ",
  StyleBox["f(x)=",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{
        \(x\^5\), "+", \(x\^4\), "-", \(11  x\^3\), "-", \(9  x\^2\), "+", 
          \(18  x\), "+", "10", 
          StyleBox["  ",
            FontSlant->"Italic"]}], TraditionalForm]]],
  "en el intervalo [-4,4]."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = x^5 + x^4 - 11  x^3 - 9  x^2 + 18  x + 10; \n\n
    Plot[f[x], {x, \(-4\), 4}]; \)}], "Input"],

Cell[TextData[{
  "A simple vista observamos que hay:\na) un m\[AAcute]ximo relativo entre -3 \
y -2,\nb) un m\[IAcute]nimo relativo entre -2 y -1,\nc) un m\[AAcute]ximo \
relativo entre 0 y 1,\nd) un m\[IAcute]nimo relativo entre 2 y 3.\nEn \
cualquier caso, y dada la simplicicidad de esta funci\[OAcute]n (polin\
\[OAcute]mica de grado no muy alto), es posible calcular directamente los \
ceros de la funci\[OAcute]n derivada con el comando ",
  StyleBox["NSolve",
    FontWeight->"Bold"],
  " (prueba con Solve y enteder\[AAcute]s por qu\[EAcute])",
  StyleBox[".",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[
    \(NSolve[\(f'\)[x] \[Equal] 0, x]\)], "Input"],

Cell["\<\
Como vemos, aparecen cuatro soluciones que se corresponden con los extremos \
que hab\[IAcute]amos localizado a simple vista.\
\>", "Text"],

Cell["Ejemplo", "Subsubsection"],

Cell[TextData[{
  "No todas  las funciones permiten calcular de un modo simple las soluciones \
de la ecuaci\[OAcute]n ",
  StyleBox["f '(x)=0",
    FontSlant->"Italic"],
  ". Por ejemplo, consideremos ahora la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")",
  StyleBox["=",
    FontSlant->"Italic"],
  "sen(x)+",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["e", 
          StyleBox["x",
            FontSlant->"Italic"]], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(en\ el\ \(\(intervalo\ [\(-7\), 0].\)\ \)\),
            FontSlant->"Plain"]}], TraditionalForm]]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = \ Sin[x] + Exp[x]; \n\nPlot[f[x], {x, \(-7\), 0}]; \)}], "Input"],

Cell[TextData[{
  "De nuevo, a simple vista se observa que hay: un m\[AAcute]ximo relativo \
cerca de -5, y un m\[IAcute]nimo relativo cerca de -2. Sin embargo, ahora no \
funciona satisfactoriamente el comando ",
  StyleBox["NSolve",
    FontWeight->"Bold"],
  " (int\[EAcute]ntalo). Optaremos por utilizar el comando ",
  StyleBox["FindRoot",
    FontWeight->"Bold"],
  " para encontrar los posibles puntos cr\[IAcute]ticos de la funci\[OAcute]n \
",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Recordemos que en este comando es necesario introducir una \"primera \
aproximaci\[OAcute]n\" de la soluci\[OAcute]n. En este caso concreto, y dada \
la informaci\[OAcute]n que hemos obtenido de la gr\[AAcute]fica, probaremos a \
iniciar el m\[EAcute]todo desde -5 y tambi\[EAcute]n desde -2."
}], "Text"],

Cell[BoxData[{
    \(FindRoot[\(f'\)[x], {x, \(-5\)}]\[IndentingNewLine]\), 
    \(FindRoot[\(f'\)[x], {x, \(-2\)}]\)}], "Input"],

Cell[TextData[{
  "El programa nos da entonces una buena aproximaci\[OAcute]n de los puntos \
donde la funci\[OAcute]n alcanza los extremos observados.\nA continuaci\
\[OAcute]n veremos un caso en el que la gr\[AAcute]fica dise\[NTilde]ada por \
el programa nos puede llevar a enga\[NTilde]o. Descubriremos el error gracias \
al \"test de la segunda derivada\". Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")",
  StyleBox["=",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\^2 - 10  x - 40 + 1\/\(10  x\^2 - 100  x + 251\)\), 
          StyleBox[",",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          
          StyleBox[
            \(y\ pint\[EAcute]mosla\ en\ el\ \(intervalo\ [\(-15\), 15].\)\),
            FontSlant->"Plain"]}], TraditionalForm]]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = \ x^2 - 10  x - 40 + 1\/\(10  x^2 - 100  x + 251\); \n\n
    Plot[f[x], {x, \(-15\), 15}]; \)}], "Input"],

Cell[TextData[{
  "Aparentemente hay un m\[IAcute]nimo cerca de 5. De hecho, si aplicamos el \
comando ",
  StyleBox["FindRoot",
    FontWeight->"Bold"],
  " con valor inicial 5, obtenemos que precisamente la derivada de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " se anula en ",
  StyleBox["x=",
    FontSlant->"Italic"],
  "5 (conclusi\[OAcute]n a la que habr\[IAcute]amos llegado antes pidi\
\[EAcute]ndole al ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que evaluara ",
  StyleBox["f '",
    FontSlant->"Italic"],
  "(5",
  StyleBox[")",
    FontSlant->"Italic"],
  "). A la vista de la gr\[AAcute]fica entonces parece que efectivamente en ",
  
  StyleBox["x=",
    FontSlant->"Italic"],
  "5 hay un m\[IAcute]nimo de la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Pero nada m\[AAcute]s lejos de la realidad, porque si evaluamos la \
derivada segunda de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en 5 obtendremos que ",
  StyleBox["f ''",
    FontSlant->"Italic"],
  "(5)= -18 < 0. La segunda derivada es negativa y por tanto en ",
  StyleBox["x=",
    FontSlant->"Italic"],
  "5 tiene que haber un m\[AAcute]ximo.\n"
}], "Text"],

Cell[BoxData[{
    \(FindRoot[\(f'\)[x], {x, 5}]\n\), 
    \(\(\(f'\)'\)[5]\)}], "Input"],

Cell["\<\
Ser\[IAcute]a  conveniente, entonces, ver \"m\[AAcute]s de cerca\" lo que \
ocurre cerca de 5. Prueba a pintar la funci\[OAcute]n en el intervalo [4,6]. \
Ahora parece haber un m\[IAcute]nimo cerca de 4.5 y otro cerca de 5.5, y, \
efectivamente, un m\[AAcute]ximo en 5...\[DownQuestion]C\[OAcute]mo podemos \
asegurar que cerca de los extremos que ahora vemos no vuelven a ocurrir \
nuevas \"oscilaciones ocultas\" como la que antes no ve\[IAcute]amos?...\
\>", "Text"],

Cell["Ejemplo", "Subsubsection"],

Cell["\<\
En la relaci\[OAcute]n de problemas de clase tienes el siguiente ejercicio: \
se desa construir una ventana con forma de rect\[AAcute]ngulo coronado de un \
semic\[IAcute]rculo de di\[AAcute]metro igual a la base del \
rect\[AAcute]ngulo. Pondremos cristal blanco en la parte rectangular y \
cristal de color en el semic\[IAcute]rculo. Sabiendo que el cristal coloreado \
deja pasar la mitad de luz (por unidad de superficie) que el blanco, calcular \
las dimensiones para conseguir la m\[AAcute]xima luminosidad si se ha de \
mantener el per\[IAcute]metro constante dado.\
\>", "Text"],

Cell[TextData[{
  "Llamemos x a la longitud de la base de la ventana y h a su altura. El per\
\[IAcute]metro es  una cantidad dada A; es decir, \n",
  StyleBox["x+2 h+",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\[Pi]\ x\)\/2 = A\)],
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"],
  " Despejamos h en funci\[OAcute]n de x:"
}], "Text"],

Cell[BoxData[
    \(Solve[x + 2  h + \(Pi\ x\)\/2 == A, h]\)], "Input"],

Cell[TextData[{
  "La luminosidad viene dada por\n       ",
  StyleBox["f(x) = 2 x h ",
    FontSlant->"Italic"],
  "+ \[Pi] ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\/8 = x\ (\)]],
  StyleBox["A - x - ",
    FontSlant->"Italic"],
  "\[Pi]",
  Cell[BoxData[
      \(TraditionalForm
      \`\(x\/2)\)\  + \ \[Pi]\ x\^2\/8 = \ 
        A\ x\  - \(1\/8\) \((8 + 3  \[Pi])\) x\^2\)]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = A*x\  - \(1\/8\) \((8 + 3  Pi)\)\ x^2\)}], "Input"],

Cell["Calculamos los puntos cr\[IAcute]ticos:", "Text"],

Cell[BoxData[
    \(puntos = Solve[\(f'\)[x] == 0, x]\)], "Input"],

Cell[" y, por \[UAcute]ltimo comprobamos que dicho punto es un \
m\[AAcute]ximo:", "Text"],

Cell[BoxData[
    \(\(\(f'\)'\)[x] /. puntos\)], "Input"],

Cell["Ejercicios", "ExerciseMain"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  " Calcula los puntos cr\[IAcute]ticos (puntos donde se anula la derivada)  \
de \n",
  Cell[BoxData[
      \(TraditionalForm
      \`f(x) = 0.487856844000000045`\ x - 0.417176730000000084`\ x\^2 - 
          4.13604445200000103`\ x\^3 + 3.01853713499999765`\ x\^4 + \n\t\t
          13.044581959999999`\ x\^5 - 13.0802496666666723`\ x\^6 - 
          0.983014285714284596`\ x\^7 + 1.07624999999999926`\ x\^8 - 
          9.44444444444444641`\ x\^9 + 10\ x\^10\)]],
  "\ny usa la derivada segunda para clasificar los puntos cr\[IAcute]ticos \
reales. Calcula los puntos de inflexi\[OAcute]n. Finalmente, representa gr\
\[AAcute]ficamente la funci\[OAcute]n en un intervalo apropiado para \
confirmar los resultados obtenidos.\n "
}], "ExerciseText"]
}, Open  ]],

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula las tangentes a la hip\[EAcute]rbola ",
  Cell[BoxData[
      \(TraditionalForm\`x\ y = 1\)]],
  " que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  ". Haz una representaci\[OAcute]n gr\[AAcute]fica.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula las tangentes a la gr\[AAcute]fica de  ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\ x\^3 + 13  x\^2 + 5  x + 9\)]],
  " que pasan por el origen. Haz una representaci\[OAcute]n gr\[AAcute]fica."
}], "ExerciseText"],

Cell["Ejercicio 3", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en azul \
los cocientes incrementales de la funci\[OAcute]n seno \"cocienteinc[Sin, \
h][x]\" (ver definici\[OAcute]n arriba) para h variando desde -2 a -0.1 con \
incrementos de 0.2, la funci\[OAcute]n seno en rojo y la funci\[OAcute]n \
coseno, su funci\[OAcute]n derivada, en verde, para x entre -2Pi y 2Pi.\
\>", "ExerciseText"],

Cell["Polinomios de Taylor", "Section"],

Cell["\<\
En la secci\[OAcute]n dedicada a rectas secantes y tangentes hemos visto c\
\[OAcute]mo la recta tangente a una funci\[OAcute]n en un punto aproxima \
localmente a dicha funci\[OAcute]n en ese punto. Es decir, que si sutituimos \
una funci\[OAcute]n por su recta tangente en un punto, estamos cometiendo un \
error como se puede ver.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = Cos[x]; \n\n
    Plot[{f[x], \(tangente[f, 0]\)[x]}, {x, \(-3\), 3}, 
      PlotStyle -> {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]; \)}], "Input"],

Cell[TextData[{
  "En cuanto nos alejamos un poco del punto de tangencia (en este caso el 0), \
la funci\[OAcute]n coseno y su tangente no se parecen en nada. La forma de \
mejorar la aproximaci\[OAcute]n ser\[AAcute] aumentar el grado del polinomio \
que usamos, y la cuesti\[OAcute]n es, fijado un grado ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", qu\[EAcute] polinomio de grado menor o igual al fijado es el que m\
\[AAcute]s se parece a la funci\[OAcute]n. El criterio con el que elegiremos \
el polinomio ser\[AAcute] hacer coincidir las sucesivas derivadas, esto es, \
el polinomio de Taylor de orden ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ":"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(T(f, a, n)\)\ \((x)\)\), "  ", "=", " ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["f",
                    FontSlant->"Italic"], "(", "a", ")"}], "+", 
                \(f\ ' \((a)\) \((x - a)\)\), "+", "   ", 
                \(\(\(\(f\ '\)' \((a)\)\)\/\(2!\)\) \((x - a)\)\^2\), "+"}], 
              "..."}], "+", 
            \(\(\(\(f\^\((n)\)\)(a)\)\/\(n!\)\) \((x - a)\)\^n\)}], "=", 
          RowBox[{\(f(a)\), "+", 
            
            FormBox[\(\[Sum]\+\(k = 1\)\%n\(\(\( f\^\((k)\)\)(a)\)\/\(k!\)\) 
                  \((x - a)\)\^k\),
              "TraditionalForm"]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "tiene una orden que permite calcular directamente el polinomio de Taylor \
centrado en un punto ",
  StyleBox["a",
    FontSlant->"Italic"],
  ". Se trata del comando ",
  "Series[f[x],{x,a,n}]] ."
}], "Text"],

Cell[BoxData[
    \(Series[f[x], {x, 0, 2}]\)], "Input"],

Cell[TextData[{
  "Observa que al final del desarrollo del polinomio (en este caso de grado \
2) aparece el orden de error (",
  StyleBox["O",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\([x\^3]\))\)\ \)\)]],
  " representa que los t\[EAcute]rminos que faltan son todos de grado mayor o \
igual que tres. Si quieres usar directamente el resultado   (sin que aparezca \
el orden de error) puedes utilizar el comando ",
  StyleBox["Normal[]",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[
    \(Normal[%]\)], "Input"],

Cell["\<\
Este comando simplemente elimina el orden de error de la expresi\[OAcute]n \
que obtenemos con el comando Series, quedado s\[OAcute]lo el polinomio de \
Taylor.
En nuestro ejemplo, para comparar la funci\[OAcute]n coseno y su \
correspondiente polinomio de Taylor de grado 4 en cero haremos lo siguiente\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = Cos[x]; \n\ng[x_] = Normal[Series[f[x], {x, 0, 4}]]; \n\n
    Plot[{f[x], g[x]}, {x, \(-Pi\), Pi}, 
      \[IndentingNewLine]PlotStyle 
        \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]; \)}], "Input"],

Cell["\<\
Hasta aqu\[IAcute] hemos visto c\[OAcute]mo comparar la gr\[AAcute]fica de \
una funci\[OAcute]n con la de su polinomio de Taylor. La orden Animate o \
Table (que ya conoces) nos va a permitir hacer animaciones de la \
gr\[AAcute]fica de una funci\[OAcute]n y sus polinomios de Taylor. Por \
ejemplo\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\n\), 
    \(f[x_] = Cos[x] + Sin[x]; \[IndentingNewLine]\na = 0; \n\nb = \(-3\) Pi; 
    \n\nc = 3  Pi; \[IndentingNewLine]\norden = 30; \[IndentingNewLine]\n
    Animate[Plot[Evaluate[{f[x], Normal[Series[f[x], {x, a, n}]]}], 
        \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {x, b, c}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}, 
        \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
        PlotRange \[Rule] {\(-3\), 3}], 
      \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, orden, 1}]\)}], 
  "Input"],

Cell[TextData[{
  "Cuando se ejecuta la celda anterior, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dibuja en el intervalo [b,c] la funci\[OAcute]n y los polinomios de \
Taylor de orden 1 hasta 30 centrados en a=0."
}], "Text"],

Cell["Ejercicios", "ExerciseMain"],

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[
"Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo \
la funci\[OAcute]n seno y en azul sus polinomios de Taylor de orden n \
centrados en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz \
la representaci\[OAcute]n en el intervalo [-2Pi, 2Pi] y en el [-8Pi, 8Pi].  \
Debes fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n.Comenta lo \
que obervas. Repite la misma operaci\[OAcute]n pero centrando el desarrollo \
en a=2\[Pi]. \[DownQuestion]Cu\[AAcute]les son las diferencias?"], 
  "ExerciseText"],

Cell["Ejercicio 5", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo la \
funci\[OAcute]n arco tangente y en azul sus polinomios de Taylor de orden n \
centrados en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz \
la representaci\[OAcute]n en el intervalo [-1,1} y en  [-Pi/2, Pi/2]. Debes \
fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n. Comenta \
lo que obervas. Repite la misma operaci\[OAcute]n pero centrando el \
desarrollo en a=2. \[DownQuestion]Cu\[AAcute]les son las diferencias?\
\>", "ExerciseText"],

Cell["Ejercicio 6", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo la \
funci\[OAcute]n Log(1+x) y en azul sus polinomios de Taylor de orden n \
centrados en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz \
la representaci\[OAcute]n en el intervalo [-.9,1] y en  [-.9, 3]. Debes \
fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n. Comenta \
lo que obervas. Repite la misma operaci\[OAcute]n pero centrando el \
desarrollo en a=2. \[DownQuestion]Cu\[AAcute]les son las diferencias?\
\>", "ExerciseText"],

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Define una funci\[OAcute]n cuya sintaxis debe ser de la forma \
\"rectanormal[f,a][x]\", cuyo resultado sea la recta normal a la \
gr\[AAcute]fica de la funci\[OAcute]n f en el punto (a,f(a)). Debes definir \
una funci\[OAcute]n condicionada seg\[UAcute]n que f '(a)\[NotEqual]0 o que f \
'(a)=0.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Representa gr\[AAcute]ficamente (en una sola gr\[AAcute]fica y en azul) \
la familia de rectas normales a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\/4\)]],
  ". En la misma gr\[AAcute]fica representa tambi\[EAcute]n la \
par\[AAcute]bola en rojo y con grosor apropiado. Haz la \
representaci\[OAcute]n para x\[Element][-6,6]. Representa las rectas normales \
en los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, f(x\_k))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  " son 101 puntos igualmente espaciados en el intervalo [-6,6]. \n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Sobre la gr\[AAcute]fica anterior representa, en rojo y con grosor \
apropiado, la gr\[AAcute]fica de la curva ",
  Cell[BoxData[
      \(TextForm\`\(\(\ \)\(y = 2 + \@\(\(27\/4\) x\^2\)\%3\)\)\)]],
  " y comprueba que las rectas normales a la par\[AAcute]bola son tangentes a \
dicha curva que se llama la evoluta de la par\[AAcute]bola.\n"
}], "ExerciseText"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1280}, {0, 955}},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{995, 755},
WindowMargins->{{13, Automatic}, {Automatic, 5}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Derivadas e integrales."], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Derivadas e integrales."], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 27, 0, 81, "Title"],
Cell[1739, 51, 156, 3, 84, "Author"],
Cell[1898, 56, 39, 0, 83, "Section"],
Cell[1940, 58, 420, 8, 183, "Text"],
Cell[2363, 68, 115, 3, 83, "Section"],
Cell[2481, 73, 265, 6, 63, "Text"],
Cell[2749, 81, 219, 6, 228, "Input"],
Cell[2971, 89, 790, 19, 111, "Text"],
Cell[3764, 110, 129, 3, 176, "Input"],
Cell[3896, 115, 37, 1, 72, "Input"],
Cell[3936, 118, 61, 0, 39, "Text"],
Cell[4000, 120, 47, 1, 72, "Input"],
Cell[4050, 123, 1196, 31, 136, "Text"],
Cell[5249, 156, 89, 2, 176, "Input"],
Cell[5341, 160, 219, 6, 39, "Text"],

Cell[CellGroupData[{
Cell[5585, 170, 58, 0, 83, "Section"],
Cell[5646, 172, 1118, 34, 153, "Text"],
Cell[6767, 208, 234, 5, 148, "Input"],
Cell[7004, 215, 397, 11, 63, "Text"],
Cell[7404, 228, 89, 1, 72, "Input"],
Cell[7496, 231, 810, 24, 87, "Text"],
Cell[8309, 257, 380, 8, 254, "Input"]
}, Open  ]],
Cell[8704, 268, 165, 4, 49, "Text"],
Cell[8872, 274, 548, 10, 306, "Input"],

Cell[CellGroupData[{
Cell[9445, 288, 42, 0, 83, "Section"],
Cell[9490, 290, 112, 3, 39, "Text"],
Cell[9605, 295, 226, 3, 122, "Input"]
}, Open  ]],
Cell[9846, 301, 293, 9, 39, "Text"],
Cell[10142, 312, 44, 1, 72, "Input"],
Cell[10189, 315, 57, 1, 72, "Input"],
Cell[10249, 318, 72, 1, 72, "Input"],
Cell[10324, 321, 62, 0, 83, "Section"],
Cell[10389, 323, 815, 24, 147, "Text"],
Cell[11207, 349, 32, 0, 55, "Subsubsection"],
Cell[11242, 351, 431, 13, 63, "Text"],
Cell[11676, 366, 144, 3, 176, "Input"],
Cell[11823, 371, 605, 12, 243, "Text"],
Cell[12431, 385, 64, 1, 72, "Input"],
Cell[12498, 388, 149, 3, 39, "Text"],
Cell[12650, 393, 32, 0, 55, "Subsubsection"],
Cell[12685, 395, 706, 25, 63, "Text"],
Cell[13394, 422, 115, 2, 176, "Input"],
Cell[13512, 426, 805, 17, 135, "Text"],
Cell[14320, 445, 129, 2, 124, "Input"],
Cell[14452, 449, 905, 25, 105, "Text"],
Cell[15360, 476, 155, 3, 203, "Input"],
Cell[15518, 481, 1182, 39, 171, "Text"],
Cell[16703, 522, 89, 2, 124, "Input"],
Cell[16795, 526, 479, 7, 87, "Text"],
Cell[17277, 535, 32, 0, 55, "Subsubsection"],
Cell[17312, 537, 596, 9, 111, "Text"],
Cell[17911, 548, 383, 11, 81, "Text"],
Cell[18297, 561, 71, 1, 92, "Input"],
Cell[18371, 564, 398, 14, 80, "Text"],
Cell[18772, 580, 99, 2, 122, "Input"],
Cell[18874, 584, 55, 0, 39, "Text"],
Cell[18932, 586, 66, 1, 72, "Input"],
Cell[19001, 589, 90, 1, 39, "Text"],
Cell[19094, 592, 57, 1, 72, "Input"],
Cell[19154, 595, 34, 0, 80, "ExerciseMain"],

Cell[CellGroupData[{
Cell[19213, 599, 31, 0, 58, "Exercise"],
Cell[19247, 601, 766, 14, 181, "ExerciseText"]
}, Open  ]],
Cell[20028, 618, 31, 0, 58, "Exercise"],
Cell[20062, 620, 587, 16, 71, "ExerciseText"],
Cell[20652, 638, 31, 0, 58, "Exercise"],
Cell[20686, 640, 409, 6, 87, "ExerciseText"],
Cell[21098, 648, 39, 0, 83, "Section"],
Cell[21140, 650, 357, 6, 87, "Text"],
Cell[21500, 658, 194, 4, 202, "Input"],
Cell[21697, 664, 826, 20, 111, "Text"],
Cell[22526, 686, 781, 19, 73, "Text"],
Cell[23310, 707, 287, 10, 63, "Text"],
Cell[23600, 719, 56, 1, 72, "Input"],
Cell[23659, 722, 504, 12, 87, "Text"],
Cell[24166, 736, 42, 1, 72, "Input"],
Cell[24211, 739, 327, 6, 123, "Text"],
Cell[24541, 747, 257, 5, 254, "Input"],
Cell[24801, 754, 323, 6, 63, "Text"],
Cell[25127, 762, 598, 10, 462, "Input"],
Cell[25728, 774, 242, 6, 63, "Text"],
Cell[25973, 782, 34, 0, 80, "ExerciseMain"],
Cell[26010, 784, 31, 0, 58, "Exercise"],
Cell[26044, 786, 643, 9, 135, "ExerciseText"],
Cell[26690, 797, 31, 0, 58, "Exercise"],
Cell[26724, 799, 636, 9, 135, "ExerciseText"],
Cell[27363, 810, 31, 0, 58, "Exercise"],
Cell[27397, 812, 627, 9, 135, "ExerciseText"],
Cell[28027, 823, 31, 0, 58, "Exercise"],
Cell[28061, 825, 1423, 32, 257, "ExerciseText"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

